package parser.bnf;

import parser.*;
import java.util.*;
import token.tokenizer.*;


/**
 * BNF of BNF
 * 
 * S   ::= D | S1
 * S1  ::= lf S
 * D   ::=  WordToken "::=" E L
 * 
 * L   ::=  L2| Empty
 * L2  ::=  lf  L3
 * L3  ::=  L | D
 * 
 * E   ::=  T E1
 * E1  ::=  Empty | E1a
 * E1a ::=  "|" E
 * 
 * T   ::= T1 T2
 * T1  ::= WordToken| QuotedStringToken
 * T2  ::= Empty | T
 * 
 * This class processes a parse tree (IGrammarSymbol) of the BNF for a grammar and produces a parser visitor factory
 * that will parse a token stream conforming to that grammar. 
 * 
 * The input parameter to this visitor is a mapping that maps the string 
 * representation of a non-terminal symbol to an instance of that symbol.  
 * This tells the algorithm what all the non-terminal symbols are and 
 * therefore, what all the terminal symbols are.
 * 
 * The return value is an ITokVisitorFact that will produce a visitor 
 * capable of parsing the grammar as described by the host parse tree.
 */
public class MakeParserFactAlgo extends AGramSymVisitor<ITokVisitorFact, Object> {
  /**
   * Utility class for default error processing
   */
  private static class ErrorCmd<R, P> implements IGramSymVisitorCmd<R, P> {
    private String symbolName;
    private R returnValue;
    
    ErrorCmd(String symbolName, R returnValue) {
      this.symbolName = symbolName;
      this.returnValue = returnValue;
    }
    
    public R apply(String idx, IGrammarSymbol host, P... inps) {
      System.err.println("MakeParserFactAlgo: Invalid symbol encountered when processing "+symbolName+" symbol = "+host);
      return returnValue;  
    }   
  }
  
  
  private ITokenizer tok;
  private Map<String,IGrammarSymbol> nonTerminals;
  private Map<String,ProxyFact> proxies = new HashMap<String, ProxyFact>();
  
  public MakeParserFactAlgo(ITokenizer aTok, Map<String,IGrammarSymbol> aNonTerminals) {
    super(new ErrorCmd<ITokVisitorFact, Object>("S", null));   
    this.tok = aTok;
    this.nonTerminals = aNonTerminals;
    
    //STUDENT TO COMPLETE
    

    
  }
  
  private AGramSymVisitor<ITokVisitorFact, Object> dAlgo = new  AGramSymVisitor<ITokVisitorFact, Object>(new ErrorCmd<ITokVisitorFact, Object>("E", null)){
    //Initializer block
    {
      setCmd("D", new IGramSymVisitorCmd<ITokVisitorFact,Object>() {
        public ITokVisitorFact apply(String idx, IGrammarSymbol host, Object... inps) {
         //STUDENT TO COMPLETE
          
          return null; // Stub code
        }
      });
    }
  };
  
  private IGramSymVisitor<ITokVisitorFact, Object> eAlgo = new  AGramSymVisitor<ITokVisitorFact, Object>(new ErrorCmd<ITokVisitorFact, Object>("E", null)){
    //Initializer block
    {
      setCmd("E", new IGramSymVisitorCmd<ITokVisitorFact,Object>() {
        public ITokVisitorFact apply(String idx, IGrammarSymbol host, Object... inps) {
          SequenceSymbol tSymbol = (SequenceSymbol)((SequenceSymbol)host).getSymbol1();
          IGrammarSymbol e1Symbol = ((SequenceSymbol)host).getSymbol2();
          
          ITokVisitorFact tFact = tSymbol.execute(tAlgo);
          
          // Delegate to E1
          ITokVisitorFact eFact = e1Symbol.execute(new  AGramSymVisitor<ITokVisitorFact, ITokVisitorFact>(new ErrorCmd<ITokVisitorFact, ITokVisitorFact>("E1", tFact)){
            AGramSymVisitor<ITokVisitorFact, ITokVisitorFact> this_E1_algo = this;
            //Initializer block
            {
              setCmd("E1a", new IGramSymVisitorCmd<ITokVisitorFact,ITokVisitorFact>() {
                public ITokVisitorFact apply(String idx, IGrammarSymbol e1aHost, ITokVisitorFact... tFacts) {
                  ITokVisitorFact e1aFact = ((SequenceSymbol)e1aHost).getSymbol2().execute(eAlgo);;
                  return new CombinationFact("E1", tok, tFacts[0], e1aFact);  // return combination
                }
              });
              setCmd("MTSymbol", new IGramSymVisitorCmd<ITokVisitorFact,ITokVisitorFact>() {
                public ITokVisitorFact apply(String idx, IGrammarSymbol e1aHost, ITokVisitorFact... tFacts) {
                  return tFacts[0];
                }
              });
            }
          }, tFact);
          return eFact;
        }
      });
    }  
  };
  
  
  private IGramSymVisitor<ITokVisitorFact, Object> tAlgo = new  AGramSymVisitor<ITokVisitorFact, Object>(new ErrorCmd<ITokVisitorFact, Object>("T", null)){
    //Initializer block
    {
      setCmd("T", new IGramSymVisitorCmd<ITokVisitorFact,Object>() {
        public ITokVisitorFact apply(String idx, IGrammarSymbol host, Object... inps) {
          
          // make factory from T1
          ITokVisitorFact t1Fact = ((SequenceSymbol)host).getSymbol1().execute(new  AGramSymVisitor<ITokVisitorFact, Object>(new ErrorCmd<ITokVisitorFact, Object>("T1", null)){
            {
              setCmd("WordToken", new IGramSymVisitorCmd<ITokVisitorFact,Object>() {
                public ITokVisitorFact apply(String idx, IGrammarSymbol host, Object... inps) {
                  IGrammarSymbol s = nonTerminals.get(host.toString());
                  if(null == s) { 
                    // terminal symbol
                    // Need to check if it is an empty terminal token
                    if("Empty".equals(host.toString())) {
                      return new MTSymbolFact(tok);
                    }
                    else {
                      return new TerminalSymbolFact(host.toString(), tok);
                    }
                  }
                  else {
                    // non-terminal symbol
                    // non-terminals and proxies queried separately to allow for future changes
                    // to code to allow non-terminals not in loops to have to have a proxy.
                    return proxies.get(s.toString());  // return the proxy
                  }
                }
              });
              
              setCmd("QuotedStringToken", new IGramSymVisitorCmd<ITokVisitorFact,Object>() {
                public ITokVisitorFact apply(String idx, IGrammarSymbol host, Object... inps) {
                  // quoted string tokens are never non-terminals
                  return new TerminalSymbolFact(host.toString(), tok);
                }
              });
            }
          });
          // Delegate to T2 since it depends on whether or not the sequence terminates.
          return ((SequenceSymbol)host).getSymbol2().execute(new  AGramSymVisitor<ITokVisitorFact, ITokVisitorFact>(new ErrorCmd<ITokVisitorFact, ITokVisitorFact>("T2", t1Fact)){
            {
              setCmd("T", new IGramSymVisitorCmd<ITokVisitorFact,ITokVisitorFact>() {
                public ITokVisitorFact apply(String idx, IGrammarSymbol host, ITokVisitorFact... facts) {
                  return new SequenceFact("T_"+facts[0], tok, facts[0], host.execute(tAlgo));
                }
              });        
              setCmd("MTSymbol", new IGramSymVisitorCmd<ITokVisitorFact,ITokVisitorFact>() {
                public ITokVisitorFact apply(String idx, IGrammarSymbol host, ITokVisitorFact... facts) {
                  return facts[0];
                }
              });        
            }
          }, t1Fact);
        }
      });
    }
  };
  
  private AGramSymVisitor<ITokVisitorFact, Object> lAlgo = new  AGramSymVisitor<ITokVisitorFact, Object>(new ErrorCmd<ITokVisitorFact, Object>("L", null)){
    //Initializer block
    {
      setCmd("L2", new IGramSymVisitorCmd<ITokVisitorFact,Object>() {
        public ITokVisitorFact apply(String idx, IGrammarSymbol l2Host, Object... nu) {
          System.err.println("Processing L2: "+l2Host);
          return ((SequenceSymbol)l2Host).getSymbol2().execute(new AGramSymVisitor<ITokVisitorFact, Object>(new ErrorCmd<ITokVisitorFact, Object>("L3", null)) {
            //Initializer block
            {
              setCmds(lAlgo.getCmds());
              setCmds(dAlgo.getCmds());
            }
          });
        }
      });
      
      setCmd("MTSymbol", new IGramSymVisitorCmd<ITokVisitorFact,Object>() {
        public ITokVisitorFact apply(String idx, IGrammarSymbol l2Host, Object... nu) {
          return null;
        }
      });
    }
  };
  
  private IGrammarSymbol getNthInSequence(IGrammarSymbol h, int n) {
    IGrammarSymbol s = h;
    for(int i=0; i<n;i++) {
      s = ((SequenceSymbol)s).getSymbol2();
    }
    return s;
  }
}

